# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
# Based on the 0.59.1 ebuild by Ben Lutgens <blutgens@gentoo.org>
# $Header: /var/cvsroot/gentoo-x86/app-emulation/xmame/xmame-0.60.1-r3.ebuild,v 1.7 2003/02/13 07:19:03 vapier Exp $

IUSE="sdl dga esd opengl"

S=${WORKDIR}/${P}
DESCRIPTION="Multiple Arcade Machine Emulator for X11"
SRC_URI="http://x.mame.net/download/${P}.tar.bz2"
HOMEPAGE="http://x.mame.net"

SLOT="0"
LICENSE="xmame"

DEPEND="virtual/x11
	sdl? ( >=media-libs/libsdl-1.2.0 )
	>=sys-libs/zlib-1.1.3-r2"

# Please note modifications for ppc in this ebuild.  If you update the ebuild,
# please either test on ppc, or send it to a ppc developer for testing before
# you commit the ebuild.  Thanks :-)

KEYWORDS="x86 ppc"

src_unpack() {
	unpack ${A}
	cd ${S}

	sed -e "s:CFLAGS    = -O -Wall:\#CFLAGS=:g" -e \
	"s:PREFIX = /usr/local:PREFIX = /usr:g" -e \
	"s:MANDIR = \$\(PREFIX\)/man/man6:MANDIR = \$\(PREFIX\)/share/man/man6:g" \
	makefile.unix > makefile.unix.tmp
	mv makefile.unix.tmp makefile.unix

	if [ ${ARCH} = "x86" ]
	then
		# Enable joystick support
		sed -e "s/\# JOY_I386/JOY_I386/g" makefile.unix > makefile.unix.tmp
		mv makefile.unix.tmp makefile.unix
	fi

	if [ ${ARCH} = "ppc" ]
	then
		sed -e "s:MY_CPU = i386:\#MY_CPU = i386:g" -e \
		"s:\# MY_CPU = risc$:MY_CPU = risc:" makefile.unix > makefile.unix.tmp
	        mv makefile.unix.tmp makefile.unix
	fi

	if [ "`use dga`" ]; then
		sed -e "s/\# X11_DGA = 1/X11_DGA = 1/g" \
		makefile.unix > makefile.unix.tmp
		mv makefile.unix.tmp makefile.unix
	fi

	if [ "`use sdl`" ]; then
		sed -e "s:DISPLAY_METHOD = x11:DISPLAY_METHOD = SDL:g" \
		makefile.unix > makefile.unix.tmp
		mv makefile.unix.tmp makefile.unix
	fi
	
	if [ "`use esd`" ]; then
		sed -e "s/\# SOUND_ESOUND/SOUND_ESOUND/g" makefile.unix > Makefile
	else
		mv makefile.unix Makefile
	fi

	if [ "`use opengl`"; then
		sed -e "s:DISPLAY_METHOD = x11:DISPLAY_METHOD = xgl:g" \
			makefile.unix > makefile.unix.tmp
		mv makefile.unix.tmp makefile.unix
	fi
}

src_compile() {
	local MYFLAGS
	MYFLAGS=""

	if [ ${ARCH} = "ppc" ] ; then
		# add Makefile suggested flags for ppc
		MYFLAGS="${CFLAGS} -funroll-loops \
		-fstrength-reduce -fomit-frame-pointer -ffast-math -fsigned-char"
	else
		MYFLAGS="${CFLAGS}"

		# rphillips 23 Jul 2002
		# compile doesn't work on x86 platforms with -O3 optimizations
		MYFLAGS=`echo $MYFLAGS | sed 's/-O3/-O2/'`
	fi
	emake CFLAGS="${MYFLAGS}" || die
}

src_install () {

	make \
		PREFIX=${D}/usr \
		MANDIR=${D}/usr/share/man/man6 \
		install

	dodoc doc/{changes.*,dga2.txt,gamelist.mame,readme.mame,xmamerc.dist}
	dodoc doc/{xmame-doc.ps,xmame-doc.txt}

	dohtml -r doc

	if [ "`use sdl`" ]; then
		dosym xmame.SDL /usr/bin/xmame
	else
		dosym xmame.x11 /usr/bin/xmame
	fi
}
