# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License, v2 or later
# $Header: /var/cvsroot/gentoo-x86/sys-apps/module-init-tools/module-init-tools-0.9.9.ebuild,v 1.4 2003/02/17 23:31:11 azarah Exp $

# This includes backwards compatability for stable kernels
IUSE=""

inherit flag-o-matic

inherit eutils

MYP="${P/_pre1/-pre}"
S="${WORKDIR}/${MYP}"
MODUTILS_PV="2.4.22"
DESCRIPTION="Kernel module tools for the development kernel >=2.5.48"
SRC_URI="http://www.kernel.org/pub/linux/kernel/people/rusty/modules/${MYP}.tar.bz2
		http://www.kernel.org/pub/linux/utils/kernel/modutils/v2.4/modutils-${MODUTILS_PV}.tar.bz2"
HOMEPAGE="http://www.kernel.org/pub/linux/kernel/people/rusty/modules"

KEYWORDS="~x86 ~ppc ~sparc ~alpha"
LICENSE="GPL-2"
SLOT="0"

DEPEND="virtual/glibc"
RDEPEND=">=sys-kernel/development-sources-2.5.48"

src_unpack() {
	unpack ${A}

	cd ${S}
	# Hack to make modprobe use /etc/modprobe.devfs and not /etc/modules.devfs
	# <azarah@gentoo.org> (18 Feb 2002)
	epatch ${FILESDIR}/${P}-devfs-hack.patch
}

src_compile() {
	filter-flags -fPIC

	einfo "Building modutils..."
	cd ${WORKDIR}/modutils-${MODUTILS_PV}

	econf \
		--disable-strip \
		--prefix=/ \
		--enable-insmod-static \
		--disable-zlib \
		${myconf}
	emake || die "emake modultils failed"

	einfo "Building module-init-tools..."
	cd ${S}

	econf \
		--prefix=/ \
		${myconf}

	emake || die "emake module-init-tools failed"
}

src_install () {

	cd ${WORKDIR}/modutils-${MODUTILS_PV}
	einstall prefix="${D}"
	dodoc COPYING CREDITS ChangeLog NEWS README TODO

	cd ${S}
	# This copies the old version of modutils to *.old so it still works
	# with kernels <= 2.4
	# This code was borrowed from the module-init-tools Makefile
	for f in lsmod modprobe rmmod depmod insmod; do
		if [ -L ${D}/sbin/${f} ]; then
			ln -sf `ls -l ${D}/sbin/${f} | \
				sed 's/.* -> //'`.old ${D}/sbin/${f};
		fi;
		mv ${D}/sbin/${f} ${D}/sbin/${f}.old;
	done
#	make prefix=${D} move-old-targets || die "Renaming old bins to *.old failed"

	einstall prefix=${D}

	# Install the modules.conf2modprobe.conf tool, so we can update
	# modprobe.conf.
	into /
	dosbin ${S}/generate-modprobe.conf

	# Create the new modprobe.conf
	dodir /etc

	if [ -f /etc/modules.conf ]; then
		einfo "Generating /etc/modprobe.conf ..."
		PATH="${D}/sbin:${PATH}" \
		${S}/generate-modprobe.conf ${D}/etc/modprobe.conf \
			|| die "Could not create modprobe.conf"
	fi
	if [ ! -f ${ROOT}/etc/modprobe.devfs ]; then
		# Support file for the devfs hack .. needed else modprobe borks.
		# Baselayout-1.8.6.3 or there abouts will have a modules-update that
		# will correctly generate /etc/modprobe.devfs ....
		echo "### This file is automatically generated by modules-update" \
			> ${D}/etc/modprobe.devfs
	fi

	dodoc AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
}

pkg_postinst() {
	# Notify user of evilness, hope for a better way ;-)
	echo ""
 	einfo "This overwrites the modutils files, so if you remove this,"
 	einfo "remember to remerge modutils.  However, this package has"
 	einfo "installed a copy of the modutils files with suffix .old"
 	einfo "in your /sbin directory, which will automatically be used"
	einfo "when needed."
	echo ""
}



pkg_postrm() {
	if [ "$(best_version ${PN})" == "${CATEGORY}/${PF}" -a ! -f /sbin/insmod ]; then
		ewarn "Uninstalling module-init-tools has left you"
		ewarn "without a modutils installtion. we recommend"
		ewarn "emerging modutils immediately or remerging"
		ewarn "module-init-tools."
	fi
}

