#!/bin/bash
# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License v2
# Author:  Martin Schlemmer <azarah@gentoo.org>
# $Header: /home/cvsroot/gentoo-src/rc-scripts/sbin/rc-envupdate.sh,v 1.14 2003/02/05 09:05:51 azarah Exp $


source /etc/init.d/functions.sh

if [ `id -u` -ne 0 ]
then
	eerror "$0: must be root."
	exit 1
fi

usage() {
cat << FOO
usage: rc-envupdate.sh

note:
      This utility generates /etc/profile.env and /etc/csh.env
      from the contents of /etc/env.d/

FOO
	exit 1
}
		
if [ "$#" -ne 0 ]
then
	usage
else
	/bin/gawk -v SVCDIR="${svcdir}" \
		-f /lib/rcscripts/awk/functions.awk \
		-f /lib/rcscripts/awk/genenviron.awk
fi


# vim:ts=4
