# Copyright 1999-2003 Gentoo Technologies, Inc.
# Distributed under the terms of the GNU General Public License, v2 or later
# $Header: /var/cvsroot/gentoo-x86/media-libs/libgphoto2/libgphoto2-2.1.1.ebuild,v 1.2 2003/02/13 12:51:08 vapier Exp $

inherit libtool
inherit flag-o-matic

IUSE="nls"
#  doc disabled since it didn't work properly here :/


S=${WORKDIR}/${P}
DESCRIPTION="free, redistributable digital camera software application"
SRC_URI="mirror://sourceforge/gphoto/${P}.tar.bz2"
HOMEPAGE="http://www.gphoto.org/"

SLOT="0"
LICENSE="GPL-2"
KEYWORDS="~x86 ~ppc"

DEPEND=">=dev-libs/libusb-0.1.6" 
# 	doc? ( dev-util/gtk-doc )"

src_compile() {
	elibtoolize

	local myconf
	use nls || myconf="${myconf} --disable-nls"
# 	use doc && myconf="${myconf} --enable-docs" || myconf="${myconf} --disable-docs"
	econf ${myconf}

	emake || die
}

src_install() {

	einstall
		gphotodocdir=${D}/usr/share/doc/${PF} \
		HTML_DIR=${D}/usr/share/doc/${PF}/sgml \
		|| die

	dodoc ChangeLog NEWS* README AUTHORS TESTERS MAINTAINERS HACKING CHANGES
	rm -rf ${D}/usr/share/doc/${PF}/sgml/gphoto2
}
